
(* 4x3 flyways 1 xbot - DO set on motion *)
FUNCTION_BLOCK Example16_DOmotion
	(*move xbot 1 to 60,60*)
	PMC_XYMotion1(PM_Controller := PM_Controller,Execute := Execute,cmdLB := 1,XbotID := 1,Mode := 0,Type_ := 0,PosX := 0.06,PosY := 0.06,EndVel := 0,MaxVel := 1,MaxAcc := 10);

	(*config DO1 to set on xbot 1 motion *)
	DoID_array5[0] := 1;
	xbotID_array5[0] := 1;
	type_array5[0] := 0;
	PMC_ConfigDO2Motion1(PM_Controller := PM_Controller,Execute := PMC_XYMotion1.Done,nDO := 1,DoID := DoID_array5,XbotID := xbotID_array5,Type_ := type_array5);

	(*move xbot 1 to 900,60*)
	PMC_XYMotion2(PM_Controller := PM_Controller,Execute := PMC_ConfigDO2Motion1.Done,cmdLB := 3,XbotID := 1,Mode := 0,Type_ := 0,PosX := 0.9,PosY := 0.06,EndVel := 0,MaxVel := 1,MaxAcc := 10);

	(*read DO 1 *)
	PMC_ReadDigitalSignalFromPMC1(PM_Controller := PM_Controller,Enable := PMC_XYMotion2.Done,DiID := 1);
	(*only record the output of the first read once*)
	IF(PMC_ReadDigitalSignalFromPMC1.Valid = TRUE AND PMC_ConfigDI2Reset1.Done = FALSE)THEN
		first_read := PMC_ReadDigitalSignalFromPMC1.Level;
	END_IF;

	(*setup DI 1 as reset for DO 1*)
	DI_ID_array22[0] := 1;
	Rst_DO_ID_array22[0] := 1;
	PMC_ConfigDI2Reset1(PM_Controller := PM_Controller,Execute := PMC_ReadDigitalSignalFromPMC1.Valid,nDI := 1,DiID := DI_ID_array22,RstDoID := Rst_DO_ID_array22);

	(*set DI 1 to 0*)
	PMC_SendDigitalSignalToPMC1(PM_Controller := PM_Controller,Enable := PMC_ConfigDI2Reset1.Done,DoID := 1,Level := FALSE);

	Delay1(Execute := PMC_SendDigitalSignalToPMC1.Valid,Cycles := 1);

	(*set DI 1 to 1*)
	PMC_SendDigitalSignalToPMC2(PM_Controller := PM_Controller,Enable := Delay1.Done,DoID := 1,Level := TRUE);

	Delay2(Execute := PMC_SendDigitalSignalToPMC2.Valid,Cycles := 1);

	(*read DO1*)
	PMC_ReadDigitalSignalFromPMC2(PM_Controller := PM_Controller,Enable := Delay2.Done,DiID := 1);
	second_read := PMC_ReadDigitalSignalFromPMC2.Level;

	Done := PMC_ReadDigitalSignalFromPMC2.Valid;
END_FUNCTION_BLOCK
